{smcl}
{* *! version 1.0.0 5aug2014}{...}
{title:Title}

{phang}
{bf:dsimih etodta} {hline 2} save {cmd:dsimih} results in {cmd:e()} as a {cmd:dsimih file}


{marker syntax}{...}
{title:Syntax}

{p 8 17 2}
{cmd:dsimih etodta} {it:filename} [{cmd:,} {opt replace}]


{marker description}{...}
{title:Description}

{pstd}
{cmd:dsimih etodta} exports {cmd:dsimih} results in {cmd:e()} to files.
They contain dynamic simulation results generated by {help dsimih create}.
These files are regular Stata data set files.
They do contain additional information required for the correct functioning of {cmd:dsimih} subcommands.
These files are therefore referred to as {cmd:dsimih files}.

{pstd}
It is important to note that you may not modify the data in these files.
If you do so, {cmd:dsimih} will not accept them anymore as input for its subcommands.


{marker abbreviations}{...}
{title:Abbreviations, definitions, notation, syntax elements}

{pstd}
This help entry uses terminology defined in {help svarih##abbreviations:svarih} and {help dsimih##abbreviations:dsimih}.


{marker options}{...}
{title:Options}

{phang}
{cmd:replace} permits {cmd:dsimih etodta} to overwrite an existing file.


{marker remarks}{...}
{title:Remarks}

{pstd}
Remarks are presented under the following headings:

    {help dsimih_etodta##fileextensions:File extensions}
    {help dsimih_etodta##dsimihfiles:dsimih files}
    {help dsimih_etodta##donotchangethedataindsimihfiles:Do not change the data in dsimih files}
    {help dsimih_etodta##theusingmodifier:The using modifier in dsimih subcommands}


{marker fileextensions}{...}
{title:File extensions}

{pstd}
If {it:filename} is specified without an extension, {opt .dta} is assumed.
You may wish to save all of your {cmd:dsimih files} with a {opt .dsimih} extension.
If so, specify the extension in {it:filename} explicitly.

{marker dsimihfiles}{...}
{title:dsimih files}

{pstd}
{cmd:dsimih files} are regular Stata data set files but they do contain additional information required for the correct functioning of dsimih subcommands.
The files therefore can only be properly constructed by {cmd:dsimih etodta} and by the {opt saving()} option of {cmd:dsimih create}.

{pstd}
{cmd:dsimih files} are just one possibility where {cmd:dsimih} results can be stored.
{cmd:dsimih} results can be stored in and retrieved from three locations: {cmd:e()}, {cmd:.ster} files, and {cmd:dsimih files}.
{cmd:.ster} files are Stata estimation results files.
See {help estimates save}.
Do not confuse {cmd:dsimih files} with {cmd:.ster} files.
Whenever a {cmd:dsimih} help file talks about {cmd:dsimih files}, it refers to {cmd:dsimih} results stored in regular Stata data set files.
These files can have extensions other than {opt .dta}, {opt .dsimih} for example.

{pstd}
{cmd:dsimih files} contain the following 12 variables, in the same order:

{p2colset 9 24 24 0}{...}
{p2col:{it:variable name}}{it:description}{p_end}
{p2col:}{p_end}
{p2col:regime}regime #{p_end}
{p2col:step}forecast step/horizon{p_end}
{p2col:impulse}impulse variable{p_end}
{p2col:response}response variable{p_end}
{p2col:}{p_end}
{p2col:sirf}SIRF{p_end}
{p2col:sirf_seasmp}SIRF: asymptotic standard error{p_end}
{p2col:sirf_sebs}SIRF: standard error, parametric bootstrap{p_end}
{p2col:sirf_sebsp}SIRF: standard error, residual bootstrap{p_end}
{p2col:}{p_end}
{p2col:sfevd}SFEVD{p_end}
{p2col:sfevd_seasmp}SIRF: asymptotic standard error{p_end}
{p2col:sfevd_sebs}SIRF: standard error, parametric bootstrap{p_end}
{p2col:sfevd_sebsp}SIRF: standard error, residual bootstrap{p_end}
{p2colreset}

{pstd}
Variables 'sirf' and 'sfevd' will never contain missing values.
By contrast, the variables that carry their standard errors may contain missing values.

{pstd}
The first four variables uniquely identify observations.

{pstd}
The sort order is regime-impulse-response-step.

{marker donotchangethedataindsimihfiles}{...}
{title:Do not change the data in dsimih files}

{pstd}
{cmd:dsimih} will detect any changes in the data in {cmd:dsimih files}.
If it does, it will refuse to do anything with these files.

{pstd}
If you need to change and re-save the data, save either the original or the modified file under a different name.

{marker theusingmodifier}{...}
{title:The using modifier in dsimih subcommands}

{pstd}
{help dsimih describe}, {help dsimih use}, {help dsimih table}, and {help dsimih graph} have a {help using} modifier that allows to access DS results stored in files.
Note that {cmd:dsimih use} does not have an explicit {cmd:using} keyword since the command name renders it redundant.
For simplicity, the optional {it:filename} in {cmd:dsimih use} is also referred to as its optional {cmd:using} modifier.

{p2colset 5 7 7 0}{...}
{p2col:The following is true for all four subcommands:}{p_end}
{p2col:-}The {opt using} modifier is optional.
The default is to access DS results in {cmd:e()}.{p_end}
{p2col:-}The {it:filename} in the {opt using} modifier can be a {help estimates save:.ster} file or a {help dsimih_etodta##dsimihfiles:dsimih file}.{p_end}
{p2col:-}If {it:filename} does not have a file extension, {cmd:dsimih} looks for files with extensions {cmd:.ster} and {opt .dta}.
If it finds none, it complains.
If it finds both a {opt .dta} and a {cmd:.ster} file called {it:filename}, it complains.
If it finds just one of the two, it uses it.{p_end}
{p2col:-}{it:filename} can have other extensions than {opt .dta} or {cmd:.ster}.
In these cases, {cmd:dsimih} treats it as a Stata data set file.{p_end}
{p2colreset}{...}

{pstd}
It is important to understand that {cmd:dsimih} will never access data that you have in data set memory.
It either accesses {cmd:e()} (then the {opt using} modifier was omitted) or a file (then the {opt using} modifier was used).
For example, the command sequence

{pmore}
{cmd:. estimates use file1.ster}{break}
{cmd:. dsimih use, clear}{break}
{cmd:. estimates use file2.ster}{break}
{cmd:. dsimih table sirf}

{pstd}
will first load the contents of the estimation results file file1.ster into {cmd:e()}.
Presuming that it contains {cmd:svarih} results, the second command will load DS results now stored in {cmd:e()} into data set memory.
The third command places another set of DS results in {cmd:e()}, and these results are displayed by the {cmd:dsimih table} statement.


{marker examples}{...}
{title:Examples}

{pstd}
Excecuting the following statements will change current {cmd:e()}-results.

{pstd}
Bootstrap replication numbers are set to values that are inappropriate for analysis but appropriate for quick execution of example statements.

{pstd}
Generate example estimates (see {help svarih examples}):

{phang2}{stata webuse lutkepohl2:. webuse lutkepohl2}{p_end}
{phang2}{stata svarih examples bac_first , ereplace:. svarih examples bac_first , ereplace}{p_end}
{phang2}{stata dsimih describe , modelstats cmdline:. dsimih describe , modelstats cmdline}{p_end}

{phang2}{stata dsimih create:. dsimih create}{p_end}
{phang2}{stata "version 11.2: set seed 123456":. version 11.2: set seed 123456}{p_end}
{phang2}{stata dsimih create , bs fromb reps(10):. dsimih create , bs fromb reps(10)}{p_end}
{phang2}{stata "version 11.2: set seed 123456":. version 11.2: set seed 123456}{p_end}
{phang2}{stata dsimih create , bsp fromb reps(10):. dsimih create , bsp fromb reps(10)}{p_end}
{phang2}{stata dsimih describe:. dsimih describe}{p_end}

{pstd}
Save DS results created in {cmd:e()} to a {cmd:dsimih file}. The default file extension is {opt .dta}.

{phang2}{stata dsimih etodta dsimih_examplefile , replace:. dsimih etodta dsimih_examplefile , replace}{p_end}
{phang2}{stata describe using dsimih_examplefile.dta:. describe using dsimih_examplefile.dta}{p_end}

{pstd}
We could have saved the file under a different extension, say, {opt .dsimih}. The file would still be a regular Stata data set file.

{phang2}{stata dsimih etodta dsimih_examplefile2.dsimih , replace:. dsimih etodta dsimih_examplefile2.dsimih , replace}{p_end}
{phang2}{stata describe using dsimih_examplefile2.dsimih:. describe using dsimih_examplefile2.dsimih}{p_end}

{pstd}
The DS results in {cmd:dsimih files} can be accessed by {cmd:dsimih} subcommands via their {opt using} modifier.

{phang2}{stata dsimih describe using dsimih_examplefile.dta , all:. dsimih describe using dsimih_examplefile.dta , all}{p_end}
{phang2}{stata dsimih table sfevd using dsimih_examplefile.dta , regime(2) impulse(*inc) step(1/4 8):. dsimih table sfevd using dsimih_examplefile.dta , regime(2) impulse(*inc) step(1/4 8)}{p_end}
{phang2}{stata dsimih graph sirf  using dsimih_examplefile2.dsimih , regime(2) impulse(*inc) ustep(6):. dsimih graph sirf  using dsimih_examplefile2.dsimih , regime(2) impulse(*inc) ustep(6)}{p_end}
{phang2}{stata dsimih use dsimih_examplefile2.dsimih , clear:. dsimih use dsimih_examplefile2.dsimih , clear}{p_end}
{phang2}{stata describe:. describe}{p_end}

{pstd}
Changing the data will invalidate {cmd:dsimih files} files for usage with {cmd:dsimih} subcommands:

{phang2}{stata use dsimih_examplefile2.dsimih:. use dsimih_examplefile2.dsimih}{p_end}
{phang2}{stata drop if regime==2:. drop if regime==2}{p_end}
{phang2}{stata save, replace:. save, replace}{p_end}
{phang2}{stata capture noisily dsimih describe using dsimih_examplefile2.dsimih:. capture noisily dsimih describe using dsimih_examplefile2.dsimih}{p_end}

{phang2}{stata erase dsimih_examplefile.dta:. erase dsimih_examplefile.dta}{p_end}
{phang2}{stata erase dsimih_examplefile2.dsimih:. erase dsimih_examplefile2.dsimih}{p_end}


{marker author}{...}
{title:Author}

{phang}
Daniel C. Schneider, Goethe University Frankfurt, dan_schneider@outlook.com


{marker alsosee}{...}
{title:Also see}

{psee}
Help:
{helpb irf:[TS] irf},
{helpb dsimih},
{helpb dsimih create},
{helpb dsimih table},
{helpb dsimih graph},
{helpb dsimih describe},
{helpb dsimih use},
{helpb dsimih drop}
{p_end}

